<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.680615051 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A510" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA510CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA510INST_RETIRED / $InstructionsPerCycleCortexA510CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-A510)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA510CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA510STALL_FRONTEND / $FrontendStalledCyclesCortexA510CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA510CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA510STALL_BACKEND / $BackendStalledCyclesCortexA510CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-A510)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexA510CPU_CYCLES &gt; 0), min(($BackendBoundCortexA510STALL_SLOT_BACKEND / (8 * $BackendBoundCortexA510CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexA510CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexA510OP_SPEC &gt; 0), min(((1 - ($RetiringCortexA510STALL_SLOT / ($RetiringCortexA510CPU_CYCLES * 8))) * ($RetiringCortexA510OP_RETIRED / $RetiringCortexA510OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexA510OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexA510OP_RETIRED / $RetiredOperationsPercentageCortexA510OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexA510BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexA510BR_IMMED_RETIRED / $BranchDirectPercentageCortexA510BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexA510BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexA510BR_RETURN_RETIRED / $BranchReturnPercentageCortexA510BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA510INST_RETIRED &gt; 0), (($BranchMPKICortexA510BR_MIS_PRED_RETIRED / $BranchMPKICortexA510INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA510BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA510BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA510BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA510INST_RETIRED &gt; 0), (($ITLBMPKICortexA510ITLB_WALK / $ITLBMPKICortexA510INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA510INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA510L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA510INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA510L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA510ITLB_WALK / $ITLBWalkPercentageCortexA510L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA510L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA510L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA510L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA510INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA510L1I_CACHE_REFILL / $L1ICacheMPKICortexA510INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA510L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA510L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA510L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA510INST_RETIRED &gt; 0), (($DTLBMPKICortexA510DTLB_WALK / $DTLBMPKICortexA510INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA510INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA510L1D_TLB_REFILL / $L1DataTLBMPKICortexA510INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA510INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA510L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA510INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA510L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA510DTLB_WALK / $DTLBWalkPercentageCortexA510L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA510L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA510L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA510L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA510L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA510L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA510L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA510INST_RETIRED &gt; 0), ((($L1DCacheMPKICortexA510L1D_CACHE_REFILL_RD + $L1DCacheMPKICortexA510L1D_CACHE_REFILL_WR) / $L1DCacheMPKICortexA510INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA510L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA510L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA510L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA510INST_RETIRED &gt; 0), ((($L2CacheMPKICortexA510L2D_CACHE_REFILL_RD + $L2CacheMPKICortexA510L2D_CACHE_REFILL_WR) / $L2CacheMPKICortexA510INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA510INST_RETIRED &gt; 0), (($L3CacheMPKICortexA510L3D_CACHE_REFILL_RD / $L3CacheMPKICortexA510INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA510L3D_CACHE_RD &gt; 0), min(($L3CacheMissPercentageCortexA510L3D_CACHE_REFILL_RD / $L3CacheMissPercentageCortexA510L3D_CACHE_RD), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA510INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA510LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA510INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA510LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA510LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA510LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA510LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA510LL_CACHE_RD - $LLCacheReadHitPercentageCortexA510LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA510LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-A510)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an in-order core." expression="if(($BackendStallInterlockRateCortexA510STALL_BACKEND &gt; 0), min(($BackendStallInterlockRateCortexA510STALL_BACKEND_ILOCK / $BackendStallInterlockRateCortexA510STALL_BACKEND), 1), 0)" name="Backend Stall Interlock Rate" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundCortexA510STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexA510STALL_BACKEND_MEM / $BackendMemoryBoundCortexA510STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA510INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA510BR_IMMED_SPEC + $BranchOperationsPercentageCortexA510BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA510CRYPTO_SPEC / $CryptoOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($IntegerOperationsPercentageCortexA510DP_SPEC / $IntegerOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA510LDST_SPEC / $LoadStoreOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA510VFP_SPEC / $FloatingPointOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA510ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexA510INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexA510FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexA510INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexA510INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexA510FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexA510INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexA510INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexA510FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexA510INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA510LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA510LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA510LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA510LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA510ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA510LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-A510)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA510LD_SPEC / $LoadOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA510INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA510ST_SPEC / $StoreOperationsPercentageCortexA510INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Cortex_A510_metric_backend_bound" />
    <select-metric id="ARMv8_Cortex_A510_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Cortex_A510_metric_backend_stall_interlock_bound" />
    <select-metric id="ARMv8_Cortex_A510_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A510_metric_branch_direct_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_branch_return_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_fp16_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_fp32_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_fp64_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A510_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A510_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A510_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A510_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Cortex_A510_metric_retiring" />
    <select-metric id="ARMv8_Cortex_A510_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A510_metric_store_percentage" />
</template>
